% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpae_package.R
\docType{data}
\name{winetaste}
\alias{winetaste}
\title{Wine taste data}
\format{
A data frame with 1,250 rows and 12 columns:
\describe{
\item{fixed.acidity}{fixed acidity}
\item{volatile.acidity}{volatile acidity}
\item{citric.acid}{citric acid}
\item{residual.sugar}{residual sugar}
\item{chlorides}{chlorides}
\item{free.sulfur.dioxide}{free sulfur dioxide}
\item{total.sulfur.dioxide}{total sulfur dioxide}
\item{density}{density}
\item{pH}{pH}
\item{sulphates}{sulphates}
\item{alcohol}{alcohol}
\item{taste}{factor with levels \code{"good"} and \code{"bad"} indicating the quality
of the wine}
}
}
\source{
UCI Machine Learning Repository: \url{https://archive.ics.uci.edu/dataset/186/wine+quality}.
}
\usage{
winetaste
}
\description{
A subset related to the white variant of the Portuguese "Vinho Verde" wine,
containing physicochemical information (\code{fixed.acidity}, \code{volatile.acidity},
\code{citric.acid}, \code{residual.sugar}, \code{chlorides}, \code{free.sulfur.dioxide},
\code{total.sulfur.dioxide} , \code{density}, \code{pH}, \code{sulphates} and \code{alcohol})
and sensory (\code{taste}), which indicates the quality of the wine (it is
considered good if the median of the wine quality evaluations, made by experts,
who evaluated them between 0 = very bad and 10 = very excellent, is not less
than 6.
}
\details{
For more details, consult \url{https://www.vinhoverde.pt/en/} or the reference
Cortez et al. (2009).
}
\examples{
winetaste <- winequality[, names(winequality)!="quality"]
winetaste$taste <- factor(winequality$quality < 6,
                      labels = c('good', 'bad')) # levels = c('FALSE', 'TRUE')
str(winetaste)
}
\references{
Cortez, P., Cerdeira, A., Almeida, F., Matos, T., & Reis, J. (2009).
Modeling wine preferences by data mining from physicochemical properties.
\emph{Decision Support Systems}, 47(4), 547-553.
}
\seealso{
\code{\link{winequality}}
}
\keyword{datasets}
