% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_series.R
\name{plot_series}
\alias{plot_series}
\title{Community Time-Series Plot}
\usage{
plot_series(
  obj,
  x = seq(dim(obj$N_map)[1]),
  y = seq(dim(obj$N_map)[2]),
  time = seq(obj$sim_time),
  species = seq(dim(obj$N_map)[4]),
  trans = NULL,
  ...
)
}
\arguments{
\item{obj}{An object of class \code{sim_com_results}.}

\item{x}{Indices for the x-dimension - first dimension of the \code{obj$N_map} (default: full range).}

\item{y}{Indices for the y-dimension - second dimension of the \code{obj$N_map} (default: full range).}

\item{time}{Indices for the time-dimension - third dimension of the \code{obj$N_map} (default: full range).}

\item{species}{Indices for the species - fourth dimension of the \code{obj$N_map} (default: full range).}

\item{trans}{An optional function to apply to the calculated mean series
before plotting (e.g., \code{log}, \code{log1p}). Defaults to \code{NULL} (no transformation).}

\item{...}{Additional graphical parameters passed to \code{plot}.}
}
\value{
Invisibly returns a matrix of the mean (and possibly transformed) abundance values for each species.
}
\description{
This function plots a community time-series for a given location and time.
}
\examples{
# Read simulation data from the mrangr package
simulated_com <- get_simulated_com()

# Plot
plot_series(simulated_com)
plot_series(simulated_com, x = 5:12, y = 1:5)
plot_series(simulated_com, time = 1:5)
plot_series(simulated_com, trans = log1p)

}
