% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvmr_ivw_stan.R
\name{mvmr_ivw_stan}
\alias{mvmr_ivw_stan}
\title{Bayesian multivariate inverse variance weighted model with a choice of prior distributions fitted using RStan.}
\usage{
mvmr_ivw_stan(
  data,
  prior = 1,
  n.chains = 3,
  n.burn = 1000,
  n.iter = 5000,
  seed = 12345,
  ...
)
}
\arguments{
\item{data}{A data of class \code{\link{mvmr_format}}.}

\item{prior}{An integer for selecting the prior distributions;
\itemize{
\item \code{1} selects a non-informative set of priors;
\item \code{2} selects weakly informative priors;
\item \code{3} selects a pseudo-horseshoe prior on the causal effect.
}}

\item{n.chains}{Numeric indicating the number of chains used in the HMC estimation in rstan, the default is \code{3} chains.}

\item{n.burn}{Numeric indicating the burn-in period of the Bayesian HMC estimation. The default is \code{1000} samples.}

\item{n.iter}{Numeric indicating the number of iterations in the Bayesian MCMC estimation. The default is \code{5000} iterations.}

\item{seed}{Numeric indicating the random number seed. The default is \code{12345}.}

\item{...}{Additional arguments passed through to \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}}.}
}
\value{
An object of class \code{\link[rstan:stanfit-class]{rstan::stanfit}}.
}
\description{
Bayesian multivariate inverse variance weighted model with a choice of prior distributions fitted using RStan.
}
\examples{
if (requireNamespace("rstan", quietly = TRUE)) {
dat <- mvmr_format(
  rsid = dodata$rsid,
  xbeta = cbind(dodata$ldlcbeta,dodata$hdlcbeta,dodata$tgbeta),
  ybeta = dodata$chdbeta,
  xse = cbind(dodata$ldlcse,dodata$hdlcse,dodata$tgse),
  yse = dodata$chdse
)
suppressWarnings(mvivw_fit <- mvmr_ivw_stan(dat, refresh = 0L))
print(mvivw_fit)
rstan::traceplot(mvivw_fit)
}
}
\references{
Burgess, S., Butterworth, A., Thompson S.G. Mendelian randomization analysis with multiple genetic variants using summarized data. Genetic Epidemiology, 2013, 37, 7, 658-665 \doi{10.1002/gepi.21758}.

Stan Development Team (2020). "RStan: the R interface to Stan." R package version 2.19.3, \url{https://mc-stan.org/}.
}
