% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{plotPCA}
\alias{plotPCA}
\title{A function for plotting PCA plots.}
\usage{
plotPCA(
  mrbinResults,
  defineGroups = TRUE,
  loadings = FALSE,
  legendPosition = "bottomleft",
  annotate = TRUE,
  verbose = TRUE,
  xpd = NA
)
}
\arguments{
\item{mrbinResults}{An mrbin object}

\item{defineGroups}{Should groups be colored differently?}

\item{loadings}{Should loadings be plotted instead of scores?}

\item{legendPosition}{Where should the legend be plotted, Defaults to "left", other options include "top", "topright", etc.}

\item{annotate}{Should loadings be annotated with metabolite identities, if available in $metadata?}

\item{verbose}{Should a summary be displayed?}

\item{xpd}{Should labels be clipped to the plot region (TRUE) or exceed to margins (NA)}
}
\value{
An invisible prcomp result object
}
\description{
This function performs PCA, then plots PC1 and PC2.
}
\examples{
resetEnv()#clean up previous data from the package environment 
results<-mrbin(silent=TRUE,setDefault=FALSE,parameters=list(dimension="2D",
    binRegion=c(8,1,15,140),binwidth2D=0.1,binheight=4,solventRegion=c(5.5,4.2),
    PQNScaling="No",noiseRemoval="Yes",trimZeros="Yes",
    fixNegatives="No",logTrafo="No",PCA="No",signal_to_noise2D=10,
    example=TRUE,#only used for the package examples
    NMRfolders=c(system.file("extdata/1.mr2",package="mrbin"),
                 system.file("extdata/2.mr2",package="mrbin"),
                 system.file("extdata/3.mr2",package="mrbin")),
    NMRvendor="mrbin"))
plotPCA(results)
}
