% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/class_tgrid.R
\docType{class}
\name{stime}
\alias{stime}
\alias{tgrid-class}
\alias{tgrids-class}
\title{Get the times at which the model will be evaluated}
\usage{
stime(x, ...)
}
\arguments{
\item{x}{a model object or a mrgsims object.}

\item{...}{not used.}
}
\value{
A sorted vector of unique simulation times from the time grid in
the model object.
}
\description{
Get the times at which the model will be evaluated
}
\details{
Simulation times include the sequence of times created from
\code{start}, \code{end}, and \code{delta} and the vector of times found in \code{add}.

Making \code{end} negative (e.g. -1) will omit the \code{start-end-delta}
sequence.  Negative values are discarded from the result.
}
\examples{
## example("stime", package="mrgsolve")

mod <- mrgsolve::house(end = 12, delta = 2, add = c(11,13,15))

stime(mod)

update(mod, end = -1) \%>\% stime()

}
\keyword{internal}
