% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msig_geneSymbol.R
\name{msig_geneSymbol}
\alias{msig_geneSymbol}
\alias{msig_geneSymbol.list}
\alias{msig_geneSymbol.data.frame}
\alias{msig_geneSymbol.character}
\title{Retrieve gene by Gene Symbol from MsigDB}
\usage{
msig_geneSymbol(..., local = FALSE)

\method{msig_geneSymbol}{list}(..., local = FALSE)

\method{msig_geneSymbol}{data.frame}(..., local = FALSE)

\method{msig_geneSymbol}{character}(..., local = FALSE)
}
\arguments{
\item{...}{one or more geneset names, which can be little or capital.}

\item{local}{logical, default is FALSE, whether to extract gene symbol from local database}
}
\value{
gene symbol
}
\description{
Retrieve gene by Gene Symbol from MsigDB
}
\examples{
\donttest{
genes <- msig_geneSymbol('izadpanah_stem_cell_adipose_vs_bone_dn')
genes <- msig_geneSymbol('izadpanah_stem_cell_adipose_vs_bone_dn',
                   'REACTOME_DEGRADATION_OF_AXIN')
}
}
