% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-mtscr.R
\name{predict.mtscr}
\alias{predict.mtscr}
\alias{predict.mtscr_list}
\title{Extract scores from mtscr model}
\usage{
\method{predict}{mtscr}(object, ..., minimal = FALSE, id_col = TRUE)

\method{predict}{mtscr_list}(object, ..., minimal = FALSE, id_col = TRUE)
}
\arguments{
\item{object}{A model or a model list fitted with \code{\link[=mtscr]{mtscr()}}.}

\item{...}{Additional arguments. Currently not used.}

\item{minimal}{If \code{TRUE}, returns only the person-level scores without the original data.}

\item{id_col}{If \code{TRUE}, returns the id column in the result. If \code{FALSE}, the id column is not returned.
Only has an impact when \code{minimal = TRUE}.}
}
\value{
The return value is always a tibble but its content depends mainly on the \code{minimal} argument:
\itemize{
\item If \code{minimal = FALSE} (default), the original data frame is returned with the creativity scores columns added.
\item If \code{minimal = TRUE}, only the creativity scores are returned (i.e., one row per person).
}
}
\description{
Extract the scores from a model fitted with \code{\link[=mtscr]{mtscr()}}.
}
\section{Functions}{
\itemize{
\item \code{predict(mtscr_list)}: Extract scores from a model list fitted with \code{\link[=mtscr]{mtscr()}}.

}}
\examples{
data("mtscr_creativity", package = "mtscr")

mtscr_creativity <- mtscr_creativity |>
  dplyr::slice_sample(n = 500) # for performance, ignore

fit <- mtscr(mtscr_creativity, id, SemDis_MEAN, item, top = 1:3)

# for a single model from a list
predict(fit$top1)

# for a whole list of models
predict(fit)

# person-level scores only
predict(fit, minimal = TRUE)

# you can also achieve more classic predict() behaviour
mtscr_creativity$score <- predict(fit, id_col = FALSE)

mtscr_creativity |>
  tidyr::unnest_wider(score, names_sep = "_") # Use to expand list-col

}
