% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multe.R
\name{multe}
\alias{multe}
\title{Multiple Treatment Effects Regression}
\usage{
multe(r, treatment_name, cluster = NULL, tol = 1e-07, cw_uniform = FALSE)
}
\arguments{
\item{r}{Fitted model, output of the \code{lm} function.}

\item{treatment_name}{name of treatment variable}

\item{cluster}{Factor variable that defines clusters. If \code{NULL} (or not
supplied), the command computes heteroscedasticity-robust standard
errors, rather than cluster-robust standard errors.}

\item{tol}{Numerical tolerance for computing LM test statistic for testing
variability of the propensity score.}

\item{cw_uniform}{For the CW estimator, should the target weighting scheme
give all comparisons equal weight (if \code{FALSE}), or should it draw
from the marginal empirical treatment distribution (if \code{TRUE})?}
}
\value{
Returns a list with the following components: \describe{

\item{est_f}{Data frame with alternative estimators and standard errors for
the full sample}

\item{est_o}{Data frame with alternative estimators and standard errors for
the overlap sample}

\item{cb_f, cb_0}{Data frame with differences between PL and alternative
estimators, along with standard errors for the full, and for the overlap
sample.}

\item{n_f, n_o}{Sample sizes for the full, and for the overlap sample.}

\item{k_f, k_o}{Number of controls for the full, and for the overlap sample.}

\item{t_f, t_o}{LM and Wald statistic, degrees of freedom, and p-values for
the full and for the overlap sample, for testing the hypothesis of no
variation in the propensity scores.}

\item{pscore_sd_f, pscore_sd_o}{Standard deviation of the estimated
propensity score in the full and overlap samples.}

\item{Y, X, wgt}{Vector of outcomes, treatments and weights in the overlap
sample}

\item{Zm}{Matrix of controls in the overlap sample}
}
}
\description{
Compute contamination bias diagnostics for the partially linear (PL)
regression estimator with multiple treatments. Also report four alternative
estimators:
\describe{
\item{OWN}{The own treatment effect component of the PL estimator.}
\item{ATE}{The unweighted average treatment effect, implemented using
interacted regression.}
\item{EW}{Weighted ATE estimator based on easiest-to-estimate weighting (EW)
scheme,
implemented by running one-treatment-at-a-time regressions.}
\item{CW}{Weighted ATE estimator using easiest-to-estimate common
weighting (CW) scheme, implemented using weighted regression.}
}
}
\examples{
wbh <- fl[fl$race=="White" | fl$race=="Black" | fl$race=="Hispanic", ]
wbh <- droplevels(wbh)
r1 <- stats::lm(std_iq_24~race+factor(age_24)+female, weight=W2C0, data=wbh)
m1 <- multe(r1, treatment="race")
}
\references{
{

\cite{Paul Goldsmith-Pinkham, Peter Hull, and Michal Kolesár. Contamination
bias in linear regressions. ArXiv:2106.05024, February 2024.}
}
}
