% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_1_input.R
\name{process_1_input}
\alias{process_1_input}
\title{multiRL.input}
\usage{
process_1_input(
  data,
  colnames = list(),
  funcs = list(),
  params = list(),
  priors,
  settings = list(),
  ...
)
}
\arguments{
\item{data}{A data frame in which each row represents a single trial,
see \link[multiRL]{data}}

\item{colnames}{Column names in the data frame,
see \link[multiRL]{colnames}}

\item{funcs}{The functions forming the reinforcement learning model,
see \link[multiRL]{funcs}}

\item{params}{Parameters used by the model’s internal functions,
see \link[multiRL]{params}}

\item{priors}{Prior probability density function of the free parameters,
see \link[multiRL]{priors}}

\item{settings}{Other model settings, 
see \link[multiRL]{settings}}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
An S4 object of class \code{multiRL.input}.

  \describe{
    \item{\code{data}}{
      A \code{DataFrame} containing the trial-level raw data.
    }
    \item{\code{colnames}}{
      An S4 object of class \code{multiRL.colnames},
      specifying the column names used in the input data.
    }
    \item{\code{features}}{
      An S4 object of class \code{multiRL.features},
      containing standardized representations of states and actions
      transformed from the raw data. 
    }
    \item{\code{params}}{
      An S4 object of class \code{multiRL.params}, 
      containing model parameters.
    }
    \item{\code{priors}}{
      A \code{List} specifying prior distributions for free parameters.
    }
    \item{\code{funcs}}{
      An S4 object of class \code{multiRL.funcs},
      containing functions used in model.
    }
    \item{\code{settings}}{
      An S4 object of class \code{multiRL.settings},
      storing global settings for model estimation.
    }
    \item{\code{elements}}{
      A \code{int} indicating the number of elements within states.
    }
    \item{\code{subid}}{
      A \code{Character} string identifying the subject.
    }
    \item{\code{n_block}}{
      A \code{int} value indicating the number of blocks.
    }
    \item{\code{n_trial}}{
      A \code{int} value indicating the number of trials.
    }
    \item{\code{n_rows}}{
      A \code{int} value indicating the number of rows in the data.
    }
    \item{\code{extra}}{
      A \code{List} containing additional user-defined information.
    }
  }
}
\description{
multiRL.input
}
