% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoxMTest.R
\name{BoxMTest}
\alias{BoxMTest}
\title{Box's test for equivalence of covariance matrices}
\usage{
BoxMTest(X, cl, alpha = 0.05, test = "any")
}
\arguments{
\item{X}{A data frame with the values of numberical variables.}

\item{cl}{An normial or ordinal variable which defines groups (a partition) (must be of type \code{factor}).}

\item{alpha}{Significance level (default \code{0.05}).}

\item{test}{Wheter the F-test (\code{test = "F"}) or Chi-square (\code{test = "ChiSq"}) test should be forced (see Details). In the case of default value \code{any}, the test is chosen based on the number of units by groups.}
}
\value{
A list with the following elements:
\itemize{
\item \code{MBox} - The value of the Box's M statistic.
\item \code{ChiSq} or \code{F} - The approximation statistic test.
\item \code{p} - An observed significance level.
}
}
\description{
The function performs Box's test for testing the null hypothesis that two or more covariance matrices are equal.
}
\details{
If the size of any group is at least 20 units (sufficiently large),
the test takes a Chi-square approximation, otherwise it takes
an F approximation.
}
\examples{
BoxMTest(X = mtcars[, c(1, 3, 4, 5)], cl = as.factor(mtcars[, 2]), alpha = 0.05)
}
\references{
Stevens, J. (1996). Applied multivariate statistics for the social sciences . 1992. Hillsdale, NJ: Laurence Erlbaum.
}
\author{
Andy Liaw and Aleš Žiberna (minor modifications)
}
