% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_gradient.R
\name{metrics_gradient}
\alias{metrics_gradient}
\title{Generates optimized metrics gradient}
\usage{
metrics_gradient(
  x,
  rasterlayer = NULL,
  class = NULL,
  radius = NULL,
  metric = NULL,
  n,
  cutpoints = NULL,
  breaks = NULL,
  random = FALSE,
  output = "MLM"
)
}
\arguments{
\item{x}{An object of class 'MultiLandMetrics' generated with \code{\link[=mland_metrics]{mland_metrics()}}.}

\item{rasterlayer}{The raster layer to be considered. If
an extra raster layer must be specified, the string "ext" must precede the raster layer number
(e.g. "ext1", "ext2")}

\item{class}{The class to be considered, as a number or as a string with the name of the class.}

\item{radius}{The radius to be considered.}

\item{metric}{The metric to be considered. Metrics as extra calculations for extra raster layers must be
provided as "fun_" + the name of the function.}

\item{n}{The number of points that will comprise the gradient. See Details.}

\item{cutpoints}{A sequence of numbers that will serve as numeric approximations to select the
points that will comprise the gradient. See Details.}

\item{breaks}{A unique number with the number of breaks that will generate the cutpoints for the
specified metric values. Default is 10. See Details.}

\item{random}{Logical. If TRUE, random points will be selected.}

\item{output}{One of the following: "MLM" to return an updated version of the 'MultiLandMetrics' object provided in \code{x} (default),
"spatial" to return a 'SpatVector' with the points
of the selected landscapes, "data" to return a data.frame with the metric values information or "coords"
to return a data.frame with geographical information of the selected points.}
}
\value{
A 'MultiLandMetrics' if \code{output = "MLM"}, a 'SpatVector' if \code{output = "spatial"},
a data.frame if \code{output = "data"} or a data.frame with geographical information of the points if \code{output = "coords"}.
}
\description{
Selects a set of points whose associated landscapes comprise an optimized gradient for a given landscape metric.
}
\details{
Selects a subset of landscapes that overall will
generate an optimized gradient of values for a given landscape metric of a specified raster layer,
class and radius. One can define a gradient as optimized if
its values fulfill to cover a good range of values between a minimum and a maximum value. The
final gradient will comprise the number of points specified in argument \code{n}. Note that
only one landscape metric can be specified at a time.

The algorithm will select those points whose associated landscapes present values for the specified landscape metric that are
the most close to the specified \code{cutpoints}. Alternatively, the user can provide a number of
\code{breaks} from which the sequence of cutpoints will be generated. If both arguments are specified,
the function will consider the values inputted in \code{cutpoints}. If both arguments are NULL, the
algorithm will simply select \code{n} random points.
}
\examples{
# Generates an optimized gradient for the landscape metric "pland", for the class "Forest".
pland_gradient <- metrics_gradient(otf_metrics, rasterlayer = 1, class = "Forest",
                                   radius = 2000, metric = "pland", n = 15, breaks = 10)
# Note that, in this case, specifications for the rasterlayer and the radius are
# redundant, and could be simply ignored and left as default, asthe object otf_metrics
# only comprises a unique rasterlayer and radius.

# By default, the output is an updated version of the object otf_metrics. In order to
# inspect the returned values, let's select only the dataframe containing the
# metric's values.
foo <- subset(pland_gradient@data, metric == "pland" & classname == "Forest",
              select = value)

# Next, we output the range of values we have obtained, note there are 15 points, as
# previously specified in the function definition in the argument 'n'
round(sort(foo$value), digits = 2)

# 1.15  1.57  8.17  8.19 15.24 22.32 29.27 36.32 43.17 43.20 49.79 50.25 55.44 57.62 64.53

# Alternatively, we can define specific cutpoints around the landscapes will be selected
# in termsof its numeric closeness.
pland_gradient <- metrics_gradient(otf_metrics, rasterlayer = 1, class = "Forest",
                                   radius = 2000,metric = "pland", n = 15,
                                   cutpoints = seq(1, 60, 5))

# Again, we inspect the dataframe with the metric values to see our results.
foo <- subset(pland_gradient@data, metric == "pland" & classname == "Forest",
              select = value)

round(sort(foo$value), digits = 2)

# 1.15  6.02  6.03 10.99 15.97 20.99 26.01 31.02 35.95 41.14 41.34 45.93 51.41 54.56 55.44

# Both alternatives generated a wide-ranged gradient of values for the forest metric "pland"
}
\seealso{
\code{\link[=metrics_filter]{metrics_filter()}}
}
