% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{rf_sampler}
\alias{rf_sampler}
\title{Sample from a Random Forest Model}
\usage{
rf_sampler(fits, newdata = NULL, indices = NULL, ...)
}
\arguments{
\item{fits}{The fitted RF model from which to draw samples.}

\item{newdata}{A data.frame containing new inputs from which to sample
responses. If NULL, defaults to the data used to estimate fit.}

\item{indices}{The coordinates of the response from which to draw samples.}

\item{...}{Additional parameters passed to rf_model's predict method.}
}
\value{
y_star A data.frame of samples y associated with the new inputs.
}
\description{
This assumes a continuous response, so that the out-of-sample MSE can be used
to estimate the outcome variability \eqn{\sigma}.
}
\examples{
m <- rf_model()
fit <- estimator(m)(mpg ~ hp + wt, data = mtcars)
rf_sampler(fit, mtcars)

prf <- parallelize(ranger::ranger)
fit <- prf(mpg + disp ~ hp + wt, data = mtcars)
rf_sampler(fit, mtcars)
}
