% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-docs.R
\docType{data}
\name{images}
\alias{images}
\alias{rhino}
\alias{unicorn}
\title{Images}
\format{
An image file.
}
\description{
A TIFF photograph of Farouq the cat in a washing machine. CC-BY-SA 4.0
Richard Cotton, 2014.
}
\details{
A JPEG photograph of a greater one-horned rhinoceros (Rhinoceros unicornis)
taken in Kaziranga National Park, Assam, India. CC-BY-SA 4.0 Janette Cotton,
2016.

An SVG picture of a fat, pink winged unicorn. CC-BY-SA 4.0 Sara Lendal, 2016.

A PNG of the R logo. CC-BY-SA 4.0 The R Foundation, 2016.
}
\examples{
\dontrun{
  figure <- multi_panel_figure(
    width = c(60, 40, 40), height = c(40, 40, 40)
  )
  image_files <- system.file("extdata", package = "multipanelfigure") \%>\%
    dir(full.names = TRUE) \%>\%
    setNames(basename(.))
  figure \%>\%
    fill_panel(image_files["farouq.tiff"]) \%>\%
    fill_panel(image_files["unicorn.svg"], column = 2:3) \%>\%
    fill_panel(image_files["rhino.jpg"], row = 2:3) \%>\%
    fill_panel(image_files["Rlogo.png"], column = 2:3, row = 2:3)
}
}
