% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxpath.R
\name{cox_obj_function}
\alias{cox_obj_function}
\title{Elastic net objective function value for Cox regression model}
\usage{
cox_obj_function(
  y,
  pred,
  weights,
  lambda,
  alpha,
  coefficients,
  vp,
  view_components,
  rho
)
}
\arguments{
\item{y}{Survival response variable, must be a \code{Surv} or
\code{stratifySurv} object.}

\item{pred}{Model's predictions for \code{y}.}

\item{weights}{Observation weights.}

\item{lambda}{A single value for the \code{lambda} hyperparameter.}

\item{alpha}{The elasticnet mixing parameter, with \eqn{0 \le \alpha \le 1}.}

\item{coefficients}{The model's coefficients.}

\item{vp}{Penalty factors for each of the coefficients.}

\item{view_components}{a list of lists containing indices of coefficients and associated covariate (view) pairs}

\item{rho}{the fusion parameter}
}
\description{
Returns the elastic net objective function value for Cox regression model.
}
