% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_white_ineqmat.R
\name{make_black_ineqmat}
\alias{make_black_ineqmat}
\alias{make_gray_ineqmat}
\title{Define hyperplanes for transposition-sensitive arrangements}
\usage{
make_black_ineqmat(card)

make_gray_ineqmat(card)
}
\arguments{
\item{card}{The cardinality of the scale(s) to be studied}
}
\value{
A \code{card} by \code{card+1} inequality matrix (for \code{make_black_ineqmat()}) or
the result of combining white and black inequality matrices (in that order) for
\code{make_gray_ineqmat()}.
}
\description{
The "black" hyperplane arrangement compares a set's scale degrees
individually to the pitches of \code{edoo(card)} (where \code{card} is the
number of notes in \code{set}). This primarily has the purpose of attending
to the overall transposition level of a set. Most applications of Modal
Color Theory assume transpositional equivalence, but occasionally it
is useful to relax that assumption. Sum class (Straus 2018,
\doi{doi:10.1215/00222909-7127694}) is a natural way to track
this information, but the "black" arrangements do so qualitatively
in the spirit of modal color theory. \code{make_black_ineqmat()} returns only
the inequality matrix for the "black" arrangement, while \code{make_gray_ineqmat()}
for convenience combines the results of \code{\link[=make_white_ineqmat]{make_white_ineqmat()}} and \code{make_black_ineqmat()}.
}
\examples{
# The set (1, 4, 7)'s elements are respectively below, equal to, and
# above the pitches of edoo(3).
test_set <- c(1, 4, 7)
signvector(test_set, ineqmat=make_black_ineqmat(3))

# The result changes if you transpose test_set down a semitone:
signvector(test_set - 1, ineqmat=make_black_ineqmat(3))

# The results from signvector(..., ineqmat=make_black_ineqmat) can
# also be calculated with coord_to_edo():
sign(coord_to_edo(test_set))
sign(coord_to_edo(test_set - 1))
}
\seealso{
\code{\link[=make_white_ineqmat]{make_white_ineqmat()}}
}
