% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{sortByMutations}
\alias{sortByMutations}
\title{Sort Data by Mutation Type.}
\usage{
sortByMutations(x)
}
\arguments{
\item{x}{an object storing mutation count data}
}
\value{
an object of the same class as x, with entries sorted according to mutation types.
}
\description{
Reorder a mutationSignatures, mutationCounts, data.frame, or matrix object by
sorting entries by mutation type.
}
\details{
This function is part of the user-interface set of tools included in mutSignatures. This is an exported function.
}
\examples{
A <- data.frame(S1=1:5, S2=5:1, S3=1:5)
rownames(A) <- c("A[A>T]G", "A[C>G]G", "T[A>T]G", "T[C>G]T", "T[C>G]G")
mutSignatures::sortByMutations(A)

}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{GitHub Repo}: \url{https://github.com/dami82/mutSignatures/}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Sci Rep paper}, introducing mutS: \url{https://www.nature.com/articles/s41598-020-75062-0/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
