% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DFA.R
\name{DFA}
\alias{DFA}
\title{Analyze univariate time series and estimate long memory using Detrended Fluctuations Analysis (DFA; Peng et al., 1995)}
\usage{
DFA(X, steps = 50, brownian = FALSE, degree = 1, verbose = TRUE, cores = 1)
}
\arguments{
\item{X}{Univariate time series.}

\item{steps}{Maximum number of window sizes. These are spread logarithmically. If time series is short and steps is large, fewer window sizes are drawn. Default to \code{50}.}

\item{brownian}{Indicator whether time series is assumed to be brownian (i.e. variance increases proportional to time)}

\item{degree}{The maximum order of the detrending polynomial in the segments. This influences the smallest window size \code{minS} such that \code{minS} = \code{degree + 2}.}

\item{verbose}{Indicator whether additional info should be printed. Default to \code{TRUE}.}

\item{cores}{Number of cores used in computation. Default to \code{1}.}
}
\value{
Returns list of Root Mean Squares per window size \code{RMS_s}, the window sizes \code{S} and the estimated long memory coefficient \code{L} - the Hurst Exponent.
}
\description{
Analyze univariate time series and estimate long memory using Detrended Fluctuations Analysis (DFA; Peng et al., 1995)
}
\examples{
X <- rnorm(500) # generate Gaussian white noise (i.i.d. standard normal variables)
DFA(X = X, steps = 5) # steps = 5 is only for demonstration,
                        # use many steps instead, e.g. steps = 50!
}
\references{
Peng, C. K., Havlin, S., Stanley, H. E., & Goldberger, A. L. (1995). Quantification of scaling exponents and crossover phenomena in nonstationary heartbeat time-series. Chaos, 5, 82–87. <doi:10.1063/1.166141>
}
