\name{predict.mvout}
\alias{predict.mvout}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Predict method for Robust Multivariate Outlier Detection
}
\description{
\code{predict} method for class "mvout".
}
\usage{
\method{predict}{mvout}(object, 
        x, 
        type = c("distance", "outlier", "scores"), 
        thresh = 0.01,
        ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{
  Object of class \code{\link{mvout}}
  }
  \item{x}{
  Optional matrix of new data used for the predictions. If omitted, the original data are used if \code{keepx = TRUE} (and error is produced otherwise).
  }
  \item{type}{
  Type of prediction to return: "distance" returns the predicted Mahalanobis distance, "outlier" returns the predicted outlier status (T/F) using the specified \code{thresh}, and "scores" returns the predicted principal component or factor scores (if applicable).
  }
  \item{thresh}{
  Scalar specifying the threshold for flagging outliers (0 < thresh < 1). See \code{\link{mvout}} for details.
  }
  \item{...}{
  Additional arguments (ignored)
  }
}
\details{
Produces predictions from the input new data \code{x} using the robust parameter estimates (of location and scatter) from the input "mvout" \code{object}.
}
\value{
Returns a vector of numerics ("distance" or "scores") or logicals ("outlier").
}

%\references{
%Delgado, J. E., Elison, J. T., & Helwig, N. E. (2025). Robust Detection of Signed Outliers in Multivariate Data With Applications to
%Early Identification of Risk for Autism. Psychological Methods. (conditionally accepted)
%}
\author{
Jesus E. Delgado <delga220@umn.edu>
Nathaniel E. Helwig <helwig@umn.edu>
}
\note{
If you input the same \code{x} that was used to estimate the location and scale parameters you will obtain:

(1) the same "distance" and "scores" as output by the \code{\link{mvout}} function

(2) a potentially different "outlier" result than what is output by the \code{\link{mvout}} function

The discrepancy in (2) is because all of the observations are considered to have been excluded from the location/scatter estimation when the \code{x} argument is provided. This results in a different critical value being used for the observations that were included in the MCD estimate. For boarderline cases, this slight change in the critical value could result in a change of outlier status. 
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{mvout}} for estimation of (robust) location/scatter.
}
\examples{
# generate some data
n <- 200
p <- 2
set.seed(0)
x <- matrix(rnorm(n * p), n, p)

# thresh = 0.01
set.seed(1)    # for reproducible MCD estimate
out1 <- mvout(x)

# predicted distance (same as before)
fit1 <- predict(out1, x = x)
max(abs(fit1 - out1$distance))

# predicted outlier (differs from before)
fit1 <- predict(out1, x = x, type = "outlier")
mean(abs(fit1 == out1$outlier))

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
\keyword{ multivariate }
\keyword{ robust }
% Use only one keyword per line.
% For non-standard keywords, use \concept instead of \keyword:
% \concept{ ~cpt1 }
% \concept{ ~cpt2 }
% Use only one concept per line.
