% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Questioning_rule.R
\name{half_split}
\alias{half_split}
\title{Questioning rule (half split)}
\usage{
half_split(likelihood, states, beta, eta, Q_pool = NA)
}
\arguments{
\item{likelihood}{A vector of the likelihood distribution on the states in the structure.}

\item{states}{A state-by-problem matrix representing the structure, where an element is one if the item is included in the state, and zero otherwise.}

\item{beta}{Vector of careless error probabilities.}

\item{eta}{Vector of lucky guess error probabilities.}

\item{Q_pool}{A vector contains the pool of items for the assessment in this moment of the procedure.}
}
\value{
The item that maximizes the information (for details see, Doignon and Falmagne, 2012).
}
\description{
Rule to select the most informative item at each step of the assessment.
}
\examples{
# Consider the knowledge space and the parameters used in Brancaccio,
# de Chiusole, Stefanutti (2023) in Example 1

states<-matrix(c( 0,0,0,0,0,
                   0,0,0,0,1,
                   0,0,1,0,1,
                   0,0,0,1,1,
                   0,0,1,1,1,
                   1,0,1,0,1,
                   0,1,0,1,1,
                   1,0,1,1,1,
                   0,1,1,1,1,
                   1,1,0,1,1,
                   1,1,1,1,1), byrow=TRUE, ncol=5)
beta  <-c(.004,.03,.02,.01,.007)
eta   <-c(5e-06, 5e-05, 4e-05,.007,.08)
likelihood <-c(0,0,0,0,0,1/3,0,1/3,0,0,1/3)
Q_pool <- c(2,4,5)
half_split(likelihood,states,beta,eta,Q_pool)
}
\references{
Doignon, J.-P., & Falmagne, J.-C. (1999). Knowledge spaces. Berlin: Springer.
}
