% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_type.R
\name{compare_type}
\alias{compare_type}
\title{Function to compare type of variables of matched data frames.}
\usage{
compare_type(
  dfx = NULL,
  dfy = NULL,
  myrror_object = NULL,
  by = NULL,
  by.x = NULL,
  by.y = NULL,
  output = c("full", "simple", "silent"),
  interactive = getOption("myrror.interactive"),
  verbose = getOption("myrror.verbose")
)
}
\arguments{
\item{dfx}{a non-empty data.frame.}

\item{dfy}{a non-empty data.frame.}

\item{myrror_object}{myrror object from \link{create_myrror_object}}

\item{by}{character, key to be used for dfx and dfy.}

\item{by.x}{character, key to be used for dfx.}

\item{by.y}{character, key to be used for dfy.}

\item{output}{character: one of "full" (returns a myrror_object), "simple" (returns a dataframe), "silent" (invisible object returned).}

\item{interactive}{logical: If \code{TRUE}, print S3 method for myrror objects
displays by chunks. If \code{FALSE}, everything will be printed at once.}

\item{verbose}{logical: If \code{TRUE} additional information will be displayed.}
}
\value{
Depending on \code{output} parameter:
\itemize{
\item \code{"full"}: myrror object with \code{compare_type} slot containing a data.table of column class comparisons
\item \code{"simple"}: data.table with columns: variable, class_x, class_y, same_class
\item \code{"silent"}: invisibly returns myrror object (same as "full")
}
Returns \code{NULL} if no differences are found and \code{output = "simple"}.
}
\description{
This function compares the types of the columns in the two data frames.
}
\examples{

# 1. Standard report, myrror_object output:
compare_type(survey_data, survey_data_2, by=c('country', 'year'))

# 2. Simple output, data.table output:
compare_type(survey_data, survey_data_2, by=c('country', 'year'),
             output = 'simple')

# 3. Toggle interactvity:
compare_type(survey_data, survey_data_2, by=c('country', 'year'),
             interactive = FALSE)

# 4. Different keys (see also ?myrror):
compare_type(survey_data, survey_data_2_cap,
             by.x = c('country', 'year'), by.y = c('COUNTRY', 'YEAR'))

# 5. Using existing myrror object created by myrror():
myrror(survey_data, survey_data_2, by=c('country', 'year'))
compare_type()

}
