% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.sensor.R
\name{print.sensor}
\alias{print.sensor}
\title{Print a \code{sensor} object parameters (name, frequency and error model)}
\usage{
\method{print}{sensor}(x, ...)
}
\arguments{
\item{x}{A \code{sensor} object.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Print the \code{sensor} object name and specifications in the console.
}
\description{
Print method for a \code{sensor} object
}
\examples{
# IMU:
imu.freq <- 250
acc.mdl <- WN(sigma2 = 1.535466e-04) + RW(gamma2 = 1.619511e-10)
gyr.mdl <- WN(sigma2 = 1.711080e-03) + RW(gamma2 = 1.532765e-13)
imu.mdl <- make_sensor(
  name = "imu",
  frequency = imu.freq,
  error_model1 = acc.mdl,
  error_model2 = gyr.mdl
)
print(imu.mdl)

}
\author{
Davide Cucci, Lionel Voirol, Mehran Khaghani, Stéphane Guerrier
}
