% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbconvertR.r
\name{nbconvert}
\alias{nbconvert}
\alias{nbconvert_html}
\alias{nbconvert_latex}
\alias{nbconvert_markdown}
\alias{nbconvert_pdf}
\alias{nbconvert_rst}
\alias{nbconvert_script}
\alias{nbconvert_slides}
\title{Jupyter/IPython Notebook Conversion}
\usage{
nbconvert(
  file,
  fmt = c("html", "latex", "markdown", "pdf", "rst", "script", "slides"),
  quiet = TRUE,
  ...
)

nbconvert_html(file, quiet = TRUE, ...)
nbconvert_latex(file, quiet = TRUE, ...)
nbconvert_markdown(file, quiet = TRUE, ...)
nbconvert_pdf(file, quiet = TRUE, ...)
nbconvert_rst(file, quiet = TRUE, ...)
nbconvert_script(file, quiet = TRUE, ...)
nbconvert_slides(file, quiet = TRUE, ...)
}
\arguments{
\item{file}{A file with a .ipynbmeta extension that contains vignette metadata lines}

\item{fmt}{A format supported by \code{nbconvert}. "script" will create an .r file, and "slides" a reveal.js-powered html presentation.}

\item{quiet}{Suppress command output if TRUE (the output will always be shown on error)}

\item{...}{Ignored for now}
}
\value{
The filename of the resulting document, script or presentation
}
\description{
An R interface for using Jupyter/IPython system calls to convert .ipynb notebooks unsing meta information.
When passed "<filename>.ipynbmeta" it will convert "<filename>.ipynb" to "<filename>.<ext>".
}
\details{
Apart from the standard \code{\%\\VignetteIndexEntry{<name>}} and \code{\%\\VignetteEngine{<namespace>::<name>}} directives,
it also understands:
\enumerate{
\item{\code{\%\\VignetteTemplate{<format>}{<filename>}}}{, which will pass a \code{--template} parameter to \code{nbconvert}}
\item{\code{\%\\VignettePreprocessors{<format>}{<module>.<Preproc>[, ...]}}}{, which will pass \code{--<Format>Exporter.preprocessors=["<module>.<Preproc>",...]} to \code{nbconvert}.}
}
}
\examples{
\dontrun{
path <- system.file('doc/test-vignette.ipynbmeta', package = 'nbconvertR')
nbconvert(path, 'pdf')
}

}
