% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_util.R
\name{to.ncpen.x.mat}
\alias{to.ncpen.x.mat}
\title{Convert a \code{\link{data.frame}} to a \code{ncpen} usable \code{\link{matrix}}.}
\usage{
to.ncpen.x.mat(df, base = NULL, interact.all = FALSE,
  base.cols = NULL, exclude.pair = NULL)
}
\arguments{
\item{df}{a \code{\link{data.frame}} which includes numerical, logical and categorical columns.}

\item{base}{a base category removed from the indicator variables. This \code{base} will work as the
base case for all the categorical variables.}

\item{interact.all}{indicates whether to interact all the columns (\code{TRUE}) or not (\code{FALSE}).}

\item{base.cols}{indicates columns derived from a same column. For example, if \code{age_sq} is \code{age^2},
then \code{"age"} is a base column. Categorical columns will be automatically considered as base columns.}

\item{exclude.pair}{the pairs will be excluded from interactions. This should be a \code{\link{list}} object of pairs.
For example, \code{list(c("a1", "a2"), c("d1", "d2"))}.}
}
\value{
This returns an object of \code{\link{matrix}}.
}
\description{
This automates the processes of \code{\link{to.indicators}} and \code{\link{interact.data}}.
First, it converts categorical variables to a series of indicators.
All other numerical and logical variables are preserved.
Then, if \code{interact.all == TRUE}, all the variables are interacted.
}
\examples{
df = data.frame(num = c(1, 2, 3, 4, 5),
                ctr = c("K", "O", "R", "R", "K"),
                logi = c(TRUE, TRUE, FALSE, FALSE, TRUE),
                age = c(10, 20, 30, 40, 50),
                age_sq = c(10, 20, 30, 40, 50)^2,
                loc = c("b", "a", "c", "a", "b"),
                FTHB = c(1,0,1,0,1),
                PRM  = c(0,1,0,1,0),
                PMI  = c(1,1,0,0,0));

to.ncpen.x.mat(df, interact.all = TRUE,
   base.cols = c("age"),
   exclude.pair = list(c("FTHB", "PRM")));



}
