% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_from_df.R
\name{import_from_df}
\alias{import_from_df}
\title{Imports a data.frame in the neo4j graph database}
\usage{
import_from_df(graph, cql, toImport, periodicCommit = 1000, by = Inf, ...)
}
\arguments{
\item{graph}{the neo4j connection}

\item{cql}{the CQL query to be applied on each row of toImport.
Use the 'row' prefix to refer to the data.frame column.}

\item{toImport}{the data.frame to be imported as "row".
Use "row.FIELD" in the cql query to refer to one FIELD of the toImport
data.frame}

\item{periodicCommit}{use periodic commit when loading the data
(default: 10000).}

\item{by}{number of rows to send by batch (default: Inf).
Can be an alternative to periodic commit.}

\item{...}{further parameters for \code{\link[=cypher]{cypher()}}}
}
\description{
This function only works with localhost Neo4j instances.
}
\seealso{
\code{\link[=cypher]{cypher()}}
}
