% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/databaseCreator.R
\name{databaseCreator}
\alias{databaseCreator}
\title{Create a Database of Processed PET Image Data}
\usage{
databaseCreator(
  pattern,
  control = TRUE,
  useSequentialNumbering = FALSE,
  demo = NULL,
  quiet = FALSE
)
}
\arguments{
\item{pattern}{\code{character}. A regular expression defining the file pattern to match.
Subject identifiers are extracted from filenames based on this pattern.}

\item{control}{\code{logical}. If \code{TRUE}, files are treated as control group data;
if \code{FALSE}, as pathological group data. Default is \code{TRUE}.}

\item{useSequentialNumbering}{\code{logical}. If \code{TRUE}, assigns sequential subject numbers
instead of extracting them from filenames. Default is \code{FALSE}.}

\item{demo}{\code{data.frame}, optional. If provided, demographic information is included for each file.
Default is \code{NULL}.}

\item{quiet}{\code{logical}. If \code{TRUE}, suppresses progress messages. Default is \code{FALSE}.}
}
\value{
A \code{data.frame} combining processed voxel-level data from all matched files.
Each row represents a voxel (3D pixel). The column structure depends on input
\itemize{
  \item For the control group: \code{CN_number}, \code{z}, \code{x}, \code{y}, \code{pet}
  \item For the pathological group: \code{AD_number}, \code{z}, \code{x}, \code{y}, \code{pet}
  \item If demographics are included: additional columns \code{PPT}, \code{Group}, \code{Sex}, \code{Age}
}
}
\description{
Processes multiple PET image files matching a specified filename pattern.
Each file is processed using \code{\link{neuroCleaner}}, and the results are aggregated
into a unified data frame for functional data analysis. This function serves as a key step
in the \code{neuroSCC} workflow, bridging raw image data and Simultaneous Confidence Corridors (SCC) computation.
}
\details{
The function performs the following steps
\enumerate{
  \item Identifies image files matching the given pattern.
  \item Processes each file using \code{\link{neuroCleaner}}, optionally merging demographic data.
  \item Adds a subject identifier column (\code{CN_number} or \code{AD_number}).
  \item Aggregates all results into a single data frame.
}

If no files are successfully processed, an empty data frame is returned with a warning.

This function is typically followed by \code{\link{matrixCreator}}, which converts the output
into a matrix format for functional analysis.
}
\examples{
# NOTE: To keep runtime below CRAN limits, this example processes only 1 subject.
# You can expand the pattern to include all subjects for real use.

# Example: Create a database from a single synthetic PET image (control group)
controlPattern <- "^syntheticControl1\\\\.nii\\\\.gz$"
databaseControls <- databaseCreator(pattern = controlPattern, control = TRUE, quiet = TRUE)
head(databaseControls)

}
\seealso{
\code{\link{neuroCleaner}} for the underlying image processing function. \cr
\code{\link{matrixCreator}} for the next step in the workflow that converts
the database to a matrix format for SCC analysis.
}
