% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDimensions.R
\name{getDimensions}
\alias{getDimensions}
\title{Get Dimensions from a Neuroimaging File}
\usage{
getDimensions(file)
}
\arguments{
\item{file}{A NIfTI file object or a file path pointing to a NIfTI image.}
}
\value{
A named list with the following elements
\itemize{
  \item \code{xDim} – Number of voxels along the X axis.
  \item \code{yDim} – Number of voxels along the Y axis.
  \item \code{zDim} – Number of slices along the Z axis.
  \item \code{dim} – Total number of voxels in a 2D slice (calculated as \code{xDim * yDim}).
}
}
\description{
Extracts voxel dimension information from a NIfTI or similar neuroimaging file.
This function is designed to work with \code{\link{neuroCleaner}}, but it can also be used
independently to inspect image dimensions.
}
\details{
The function accepts either a file path or a preloaded \code{nifti} object.
If a file path is provided, it uses \code{oro.nifti::readNIfTI()} to load the image.
This function ensures consistent dimension extraction across the \code{neuroSCC} pipeline.
}
\examples{
# Get the file path for a sample NIfTI file
niftiFile <- system.file("extdata", "syntheticControl1.nii.gz", package = "neuroSCC")

# Extract dimensions from the NIfTI file
dimensions <- getDimensions(niftiFile)

# Display the extracted dimensions
print(dimensions)

}
