% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoresPlot.R
\name{scoresPlot}
\alias{scoresPlot}
\title{Function to Plot a Scores Plot}
\usage{
scoresPlot(
  nlcvObj,
  tech,
  nfeat,
  plot = TRUE,
  barPlot = FALSE,
  layout = TRUE,
  main = NULL,
  sub = NULL,
  ...
)
}
\arguments{
\item{nlcvObj}{Object of class 'nlcv' as produced by the \code{nlcv}
function}

\item{tech}{string denoting the classification technique used; one of
'dlda', 'bagg', 'pam', 'rf', or 'svm'.}

\item{nfeat}{integer giving the number of features; this number should be
part of the initial set of number of features that was specified during the
nested loop cross-validation (\code{nFeatures} argument of the \code{nlcv}
function)}

\item{plot}{logical.  If \code{FALSE}, nothing is plotted.}

\item{barPlot}{Should a barplot be drawn (\code{TRUE}) or the alternative
MCREstimate-type scores plot (the default, \code{FALSE}).}

\item{layout}{boolean indicating whether \code{mcrPlot} should prespecify a
layout for a single plot (default, \code{TRUE}) or whetherl the user takes
care of the layout (\code{FALSE})}

\item{main}{Main title for the scores plot; if not supplied, 'Scores Plot'
is used as a default}

\item{sub}{Subtitle for the scores plot; if not supplied, the classification
technique and the chosen number of features are displayed}

\item{\dots}{Additional graphical parameters to pass to the plot function}
}
\value{
A scores plot is displayed (for the device specified).

The function invisibly returns a named vector containing (for each sample)
the proportion of times the sample was correctly classified (for a given
technique and a given number of features used).
}
\description{
Function to plot, for a given nested loop cross-validation object, a given
classification technique and a given number of features used for the
classification, the scores plot. This plot diplays the proportion of
correctly-classified per sample across all runs of the nested loop
cross-validation. The class membership of the samples is displayed using a
colored strip (with legend below the plot).
}
\author{
Willem Talloen and Tobias Verbeke
}
\keyword{manip}
