% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{eval_perf_1cmpt}
\alias{eval_perf_1cmpt}
\title{Evaluates predictive performance of a one-compartment model}
\usage{
eval_perf_1cmpt(
  dat,
  est.method = "rxSolve",
  ka = NULL,
  cl = NULL,
  vd = NULL,
  route = c("bolus", "infusion", "oral")
)
}
\arguments{
\item{dat}{A data frame containing raw time–concentration data in the
standard nlmixr2 format.}

\item{est.method}{Estimation method passed to the fitting function.
Defaults to using \code{rxSolve} for model simulation and parameter estimation.}

\item{ka}{Absorption rate constant.}

\item{cl}{Clearance value.}

\item{vd}{Volume of distribution.}

\item{route}{A character string indicating the route of administration.
Must be one of \code{"oral"}, \code{"infusion"}, or \code{"bolus"}. Defaults to \code{"bolus"}.}
}
\value{
A numeric vector containing absolute prediction error, mean absolute error,
mean absolute percentage error, root mean square error, and relative root mean
square error.
}
\description{
Computes predictive error metrics by comparing simulated and observed
concentration–time data using specified pharmacokinetic parameters and dosing route.
}
\details{
Internally selects the appropriate one-compartment model fitting function, using
\code{Fit_1cmpt_oral()} for oral administration and \code{Fit_1cmpt_iv()} for intravenous administration.
Predictive performance is quantified using the \code{metrics.()} function.
}
\examples{

eval_perf_1cmpt(
  dat = Oral_1CPT,
  est.method = "rxSolve",
  ka = 1,
  cl = 4,
  vd = 70,
  route = "oral"
)

}
\seealso{
\code{\link{Fit_1cmpt_oral}}, \code{\link{Fit_1cmpt_iv}}, \code{\link{metrics.}}
}
