% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_ka.R
\name{ka_calculation_sd}
\alias{ka_calculation_sd}
\title{Estimate absorption rate constant in a one-compartment oral model}
\usage{
ka_calculation_sd(cl, ke, t, Ct, Fbio = 1, Dose)
}
\arguments{
\item{cl}{Numeric. Clearance of the drug.}

\item{ke}{Numeric. Elimination rate constant.}

\item{t}{Numeric. Time after administration.}

\item{Ct}{Numeric. Observed plasma concentration at time t.}

\item{Fbio}{Numeric. Absolute bioavailability fraction. Default is 1.}

\item{Dose}{Numeric. Administered oral dose.}
}
\value{
A list containing:
\item{ka}{Estimated absorption rate constant.}
\item{full_solution}{The full result object returned by the root-finding process.}
\item{message}{A character string indicating the status of the estimation or any warnings.}
}
\description{
This estimates the absorption rate constant in a single-dose oral model using
first-order pharmacokinetics.
}
\details{
The model assumes a one-compartment structure with first-order absorption and
first-order elimination.

The concentration-time relationship is:
\deqn{Ct = \frac{Fbio \cdot Dose \cdot ka}{Vd \cdot (ka - ke)} \left( e^{-ke \cdot t} - e^{-ka \cdot t} \right)}
where the volume of distribution is defined as:
\deqn{Vd = \frac{cl}{ke}}

ka is estimated using \code{uniroot()}, which solves for the root of the residual
function (predicted Ct - observed Ct) within a bounded interval (ka > ke and ka <= 1000)
}
\examples{
# Example from Oral_1CPT dataset (ID = 1, 1st dose, t = 0.5 h)
ka_calculation_sd(cl = 3.62, ke = 0.0556, t = 0.5, Ct = 310.6, Dose = 60000)

}
\author{
Zhonghui Huang
}
