% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/laplace.R
\name{laplaceControl}
\alias{laplaceControl}
\title{Control options for the Laplace estimation method}
\usage{
laplaceControl(sigdig = 3, ..., nAGQ = 1)
}
\arguments{
\item{sigdig}{Optimization significant digits. This controls:

\itemize{

 \item The tolerance of the inner and outer optimization is \code{10^-sigdig}

 \item The tolerance of the ODE solvers is
 \code{0.5*10^(-sigdig-2)}; For the sensitivity equations and
 steady-state solutions the default is \code{0.5*10^(-sigdig-1.5)}
 (sensitivity changes only applicable for liblsoda)

 \item The tolerance of the boundary check is \code{5 * 10 ^ (-sigdig + 1)}

}}

\item{...}{Parameters used in the default `foceiControl()`}

\item{nAGQ}{Number of Gauss-Hermite Adaptive Quadrature points to
take.  When `nAGQ=0`, the AGQ is not used.  With `nAGQ=1`, this
is equivalent to the Laplace method. The adaptive quadrature
expands every node for each of the ETAs, so it can be quite
expensive with a large amount of ETAs.  Once the EBE is obtained
for a subject, you will have nAGQ^neta additional function
evaluations for even nAGQ numbers and (nAGQ^neta)-1 additional
function evaluations for odd nAGQ numbers.}
}
\value{
laplaceControl object
}
\description{
This is the control options for the adaptive Gauss-Hermite
quadrature for the likelihood.  Note that nAGQ=1 is the same as the
Laplace method.
}
\details{
This method can be made to more closely matches NONMEM-style Laplace
estimation by requesting the log-likelihood from STAN as well as
numerically calculated Hessian matrix. This is done with adding
`+dnorm()` to the model for any normal end-points.
}
\examples{

\donttest{

laplaceControl()

# Use adaptive quadrature

# x =  Litter size after 21 days, and the modeled value

r <- rats
r$dv <- r$x

# Time is not used in this model, but it is required in nlmixr2
# currently, add a dummy value

r$time <- 0

f <- function() {
  ini({
    t1 <- 1
    t2 <- 1
    t3 <- 1
    eta1 ~ 1
  })
  model({
    lp <- t1 * x1 + t2 * x2 + (x1 + x2*t3) * eta1
    p <- pnorm(lp)
    m1 <- m # need to add outside of model specification
    x ~ dbinom(m1, p)
  })
}

fit <- nlmixr(f, r, est="laplace")


p <- pump

p$dv <- p$y
p$time <- 0 # dummy time

f <- function() {
  ini({
    t1 <- 1
    t2 <- 1
    t3 <- 1
    t4 <- 1
    eta1 ~ 1
  })
  model({
    if (group == 1) {
       lp <- t1 + t2 * logtstd
    } else {
       lp <- t3 + t4 * logtstd
    }
    lp <- lp + eta1
    lam <- exp(lp)
    y ~ dpois(lam)
  })
}

fit <- nlmixr(f, p, est="laplace")

}

}
\author{
Matthew L. Fidler
}
