% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertMM.R
\name{convertMM}
\alias{convertMM}
\title{Convert models from linear elimination to Michaelis-Menten elimination}
\usage{
convertMM(
  ui,
  central = "central",
  elimination = "kel",
  vm = "vm",
  km = "km",
  vc = "vc"
)
}
\arguments{
\item{ui}{model to convert}

\item{central}{the central compartment where the elimination is present}

\item{elimination}{variable for the elimination constant in the
model}

\item{vm}{variable name for Vmax in the model}

\item{km}{variable name for Km in the model}

\item{vc}{variable name for Vc in the model}
}
\value{
new model changing linear elimination to Michaelis-Menten elimination
}
\description{
Convert models from linear elimination to Michaelis-Menten elimination
}
\examples{

readModelDb("PK_1cmt_des") |> convertMM()

readModelDb("PK_2cmt_des") |> convertMM()

readModelDb("PK_3cmt_des") |> convertMM()

readModelDb("PK_3cmt_des") |> removeDepot() |> convertMM()
}
\author{
Matthew L. Fidler
}
