% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlts.R
\name{lin.order.cls}
\alias{lin.order.cls}
\title{The order of a time series using cross-validation of the linear
autoregressive model (conditional least-squares).}
\usage{
lin.order.cls(x, order = 1:5, n.cond = 5, echo = TRUE)
}
\arguments{
\item{x}{A time series without missing values}

\item{order}{The candidate orders. The default is 1:5}

\item{n.cond}{The number of observation to condition on.  The default is 5
(must be >= max(order))}

\item{echo}{if TRUE a counter for the data points and the orders is produced
to monitor progress.}
}
\value{
An object of class "lin.order" is returned consisting of the
following components: \item{order}{the grid of orders considered.}
\item{CVd}{the cross-validation errors across the grid of orders.}
}
\description{
A function to estimate the order of a time series using cross-validation of
the linear autoregressive model. Coefficients are estimated using
conditional least-squares. I coded this functions to estimate the order of ecological time series.
Bjornstad et al. (1998, 2001)
}
\details{
The time series is normalized prior to cross-validation.

Note that if the dynamics is highly nonlinear, the nonparametric
order-estimators (\code{\link{ll.order}}) may be more appropriate.  (I coded
this function to use for comparison with the nonparametric methods, because
these also uses (nonlinear) conditional least-squares.)
}
\examples{

    data(plodia)
    fit <- lin.order.cls(sqrt(plodia), order=1:5)
    \dontrun{plot(fit)}
    summary(fit)
}
\references{
Bjornstad, O.N., Begon, M., Stenseth, N. C., Falck, W., Sait, S. M. and Thompson, D. J. 1998. Population dynamics of the Indian meal moth: demographic stochasticity and delayed regulatory mechanisms. Journal of Animal Ecology 67:110-126. https://doi.org/10.1046/j.1365-2656.1998.00168.x
Bjornstad, O.N., Sait, S.M., Stenseth, N.C., Thompson, D.J. & Begon, M. 2001. Coupling and the impact of specialised enemies on the dimensionality of prey dynamics. Nature 401: 1001-1006. https://doi.org/10.1038/35059003
}
\seealso{
\code{\link{ll.order}}
}
\keyword{ts}
