% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlts.R
\name{lin.test}
\alias{lin.test}
\title{A Tukey one-degree-of-freedom test for linearity in time series.}
\usage{
lin.test(x, order)
}
\arguments{
\item{x}{A time series (vector without missing values).}

\item{order}{a scalar representing the order to be considered.}
}
\value{
A vector is returned consisting of the asymtpotic F-value, the
associated numerator and denominator d.f.'s and asymptotic p.val for the
test of linearity
}
\description{
a function to test the permissibility of the linear autoregressive model:
}
\details{
N(t) = a0 + a1N(t-1) + a2N(t-2) + ... + adN(t-d) + e(t )

against the alternative:

Nt = F(N(t-1), N(t-2), ..., N(t-d)) + e(t)

This is the Tukey one-degree-of-freedom test of linearity developed by Tsay
(1986). Orders up to 5 is permissible. [although the code is easily
extended].
}
\examples{

   data(plodia)
   lin.test(sqrt(plodia), order = 3)
}
\references{
Tsay, R.S. (1986) Nonlinearity tests for time series.
Biometrika, 73, 461-466. https://doi.org/10.1093/biomet/73.2.461
}
\keyword{ts}
