% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp.R
\encoding{utf8}
\name{comp}
\alias{comp}
\alias{\%comp\%}
\title{comp}
\usage{
comp(phi_1, phi_2)

phi_1 \%comp\% phi_2
}
\arguments{
\item{phi_1}{first neural network to be composed, goes on the left}

\item{phi_2}{second neural network to be composed, goes on right}
}
\value{
The composed neural network. See also \code{\link{dep}}.


Our definition derive specifically from:
}
\description{
The function that takes the composition of two neural
networks assuming they are compatible, i.e., given
\eqn{\nu_1, \nu_2 \in \mathsf{NN}}, it must be the case that
\eqn{\mathsf{I}(\nu)_1 = \mathsf{O}(\nu_2)}.
}
\examples{
create_nn(c(5, 4, 6, 7)) |> comp(create_nn(c(4, 1, 5)))
}
\references{
Definition 2.1.1. Jentzen, A., Kuckuck, B., and von Wurstemberger, P. (2023).
Mathematical introduction to deep learning: Methods, implementations,
and theory. \url{https://arxiv.org/abs/2310.20360}

\emph{Remark:} We have two versions of this function, an
infix version for close resemblance to mathematical notation and
prefix version.
}
