% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{EV.Nii}
\alias{EV.Nii}
\title{Expected Values of the Self Entries in a Species Correspondence Contingency Table (SCCT)}
\usage{
EV.Nii(ct)
}
\arguments{
\item{ct}{The NNCT or SCCT}
}
\value{
A \code{vector} of length \eqn{k} whose entries are the expected values of the self entries (i.e., first column) in a
species correspondence contingency table (SCCT) or of the diagonal entries in an NNCT.
}
\description{
Returns a \code{vector} of length \eqn{k} of expected values of the self entries (i.e., first column) in a
species correspondence contingency table (SCCT) or the expected values of the diagonal entries \eqn{N_{ii}} in an NNCT.
These expected values are valid under RL or CSR.

The argument \code{ct} can be either the NNCT or SCCT.

See also (\insertCite{ceyhan:NNCorrespond2018;textual}{nnspat}).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
ct

EV.Nii(ct)
ct<-scct(ipd,cls)
EV.Nii(ct)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

EV.Nii(ct)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

EV.Nii(ct)
ct<-scct(ipd,cls)
EV.Nii(ct)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{scct}} and \code{\link{EV.nnct}}
}
\author{
Elvan Ceyhan
}
