% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{Nt.def}
\alias{Nt.def}
\title{\eqn{N_t} Value (found with the definition formula)}
\usage{
Nt.def(a)
}
\arguments{
\item{a}{The \eqn{A=(a_{ij})} matrix. The argument \code{a} is the \eqn{A} matrix, obtained as output fromm \code{aij.mat}.}
}
\value{
Returns the \eqn{N_t} value standing for the number of triplets \eqn{(i,j,l)} \eqn{i,j}, and \eqn{l} distinct so that
\eqn{j} is among \eqn{k}NNs of \eqn{i} and \eqn{j} is among \eqn{k}NNs of \eqn{l}. See the description.
}
\description{
This function computes the \eqn{N_t} value which is required in the computation of the asymptotic variance
of Cuzick and Edwards \eqn{T_k} test. Nt is defined on page 78 of (\insertCite{cuzick:1990;textual}{nnspat}) as follows.
\eqn{N_t= \sum \sum_{i \ne l}\sum a_{ij} a_{lj}} (i.e, number of triplets \eqn{(i,j,l)} \eqn{i,j}, and \eqn{l} distinct so that
\eqn{j} is among \eqn{k}NNs of \eqn{i} and \eqn{j} is among \eqn{k}NNs of \eqn{l}).

This function yields the same result as the \code{asyvarTk} and \code{varTk} functions with \code{$Nt} inserted at the
end.

See (\insertCite{cuzick:1990;textual}{nnspat}) for more details.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
k<-2 #try also 2,3
a<-aij.mat(Y,k)
Nt.def(a)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{asyvarTk}}, \code{\link{varTk}}, and \code{\link{varTkaij}}
}
\author{
Elvan Ceyhan
}
