% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{covTcomb}
\alias{covTcomb}
\title{Covariance matrix for \eqn{T_k} values in \code{Tcomb}}
\usage{
covTcomb(dat, n1, klist, nonzero.mat = TRUE, asy.cov = FALSE, ...)
}
\arguments{
\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point.}

\item{n1}{Number of cases}

\item{klist}{\code{list} of integers specifying the indices of the \eqn{T_k} values used in obtaining the \eqn{T_{comb}}.}

\item{nonzero.mat}{A logical argument (default is \code{TRUE}) to determine whether the \eqn{A} matrix or the matrix of
nonzero locations of the \eqn{A} matrix will be used in the computation of \eqn{N_s} and \eqn{N_t}.
If \code{TRUE} the nonzero location matrix is used, otherwise the \eqn{A} matrix itself is used.}

\item{asy.cov}{A logical argument (default is \code{FALSE}) to determine whether asymptotic or exact (i.e., finite
sample) covariances between \eqn{T_k} and \eqn{T_l} values are to be used to obtain the entries of the covariance matrix.
If \code{TRUE} the asymptotic covariance values are used, otherwise exact covariance values are used.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
Returns the covariance matrix for the \eqn{T_k} values used in \code{Tcomb}.
}
\description{
This function computes the covariance matrix for the \eqn{T_k} values used in the \eqn{T_{comb}} test statistics,
which is a linear combination of some \eqn{T_k} tests. 

The argument, \eqn{n_1}, is the number of cases (denoted as \code{n1} as an argument).
The number of cases is denoted as \eqn{n_1} to match the case-control class labeling,
which is just the reverse of the labeling in \insertCite{cuzick:1990;textual}{nnspat}.

The argument \code{klist} is the \code{vector} of integers specifying the indices of the \eqn{T_k} values used
in obtaining the \eqn{T_{comb}}.

The logical argument \code{nonzero.mat} (default=\code{TRUE}) is for using the \eqn{A} matrix if \code{FALSE} or just the matrix of nonzero
locations in the \eqn{A} matrix (if \code{TRUE}) in the computations.

The logical argument \code{asy.cov} (default=\code{FALSE}) is for using the asymptotic covariance or the exact (i.e., finite
sample) covariance for the vector of \eqn{T_k} values used in \code{Tcomb}.
If \code{asy.cov=TRUE}, the asymptotic covariance is used, otherwise the exact covariance is used.
  
See page 87 of (\insertCite{cuzick:1990;textual}{nnspat}) for more details.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(0:1,n,replace = TRUE)  #or try cls<-rep(0:1,c(10,10))
n1<-sum(cls==1)

kl<-sample(1:5,3) #try also sample(1:5,2)
kl
covTcomb(Y,n1,kl)
covTcomb(Y,n1,kl,method="max")
covTcomb(Y,n1,kl,nonzero.mat = FALSE)

covTcomb(Y,n1,kl,asy=TRUE)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{asycovTkTl}}, \code{\link{covTcomb}}, and \code{\link{Ntkl}}
}
\author{
Elvan Ceyhan
}
