% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/005_clu_vot_ln.R
\name{clu_vot_ln}
\alias{clu_vot_ln}
\alias{clu_vot_ln.default}
\alias{clu_vot_ln.formula}
\title{Clustering-based voting label noise}
\usage{
\method{clu_vot_ln}{default}(x, y, k = nlevels(y), sortid = TRUE, ...)

\method{clu_vot_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{k}{an integer with the number of clusters (default: \code{nlevels(y)}).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Clustering-based voting label noise} into a classification dataset.
}
\details{
\emph{Clustering-based voting label noise} divides the dataset into \code{k} clusters.
Then, the labels of each cluster are relabeled with the majority class among its samples.
}
\note{
Noise model adapted from the papers in References, which considers \emph{k}-means as 
unsupervised clustering method.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- clu_vot_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)])

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- clu_vot_ln(formula = Species ~ ., data = iris2D)

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
Q. Wang, B. Han, T. Liu, G. Niu, J. Yang, and C. Gong. 
\strong{Tackling instance-dependent label noise via a universal probabilistic model}. 
In \emph{Proc. 35th AAAI Conference on Artificial Intelligence}, pages 10183-10191, 2021.
url:\url{https://ojs.aaai.org/index.php/AAAI/article/view/17221}.
}
\seealso{
\code{\link{sco_con_ln}}, \code{\link{mis_pre_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
