% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_noise_threshold.R
\name{calculate_noise_threshold}
\alias{calculate_noise_threshold}
\title{Function to calculate the noise threshold for a given expression matrix and parameters}
\usage{
calculate_noise_threshold(
  expression,
  similarity.threshold = 0.25,
  method.chosen = "Boxplot-IQR",
  binsize = 0.1,
  minimum.observations.per.bin = NULL,
  ...
)
}
\arguments{
\item{expression}{either an expression summary (as calculated by
\code{\link{calculate_expression_similarity_counts}} or \code{\link{calculate_expression_similarity_transcript}}),
which should be a list with 3 slots: expression.matrix, expression.levels, expression.levels.similarity;
alternatively, just an expression matrix; only density based methods are available for the latter case}

\item{similarity.threshold}{similarity (correlation or inverse distance) threshold to be used
to find corresponding noise threshold; the default, 0.25 is usually suitable for the
Pearson correlation (the default similarity measure)}

\item{method.chosen}{method to use to obtain a vector of noise thresholds,
must be one of \code{\link{get_methods_calculate_noise_threshold}}; defaults to Boxplot-IQR}

\item{binsize}{size of each bin in the boxplot methods; defaults to 0.1 (on a log-scale)}

\item{minimum.observations.per.bin}{minumum number of observations allowed in each bin of the boxplot;
if a bin has fewer observations, it is merged with the one to its left; default is calculated as:
ceiling(number of observations / number of bins / 10)}

\item{...}{arguments passed on to other methods}
}
\value{
The output is a vector of noise thresholds, the same length as the number of columns in
the expression matrix, or a single value in the case of density based methods.
}
\description{
This function is used to calculate the noise threshold for a given expression matrix.
It uses as input an expression profile, or just an expression matrix for a simple calculation based on density.
A variety of methods are available to obtain a noise threshold using an input similarity threshold.
}
\examples{
expression.summary <- calculate_expression_similarity_counts(
    expression.matrix = matrix(1:100, ncol=5),
    method = "correlation_pearson",
    n.elements.per.window = 3)
calculate_noise_threshold(expression.summary)
}
\seealso{
\code{\link{calculate_noise_threshold_method_statistics}}
}
