% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{composite_shape}
\alias{composite_shape}
\title{Shape data for a composite scale based on normalized Z-scores}
\usage{
composite_shape(normtables)
}
\arguments{
\item{normtables}{list of NormTable objects created by \code{\link[=normtable_create]{normtable_create()}}.
Each must contain \code{znorm_sample} and \code{norm_sample}.}
}
\value{
A data.frame with:
\itemize{
\item \code{age}: Age values from the first NormTable
\item \code{z_sum}: Unweighted sum of normalized z-scores across all objects
}
}
\description{
\code{composite_shape()} creates a data.frame with age values and the sum of normalized
z-scores from multiple NormTable objects, suitable for use as input to \code{\link[=fb_select]{fb_select()}}.
}
\examples{
\donttest{
invisible(data("ids_data"))

# Example with two normtables
mydata1 <- shape_data(ids_data, age_name = "age", score_name = "y7", family = "BCPE")
mod1 <- fb_select(mydata1, age_name = "age", score_name = "shaped_score",
                  family = "BCPE", selcrit = "BIC")
norm1 <- normtable_create(mod1, mydata1, age_name = "age", score_name = "shaped_score")

mydata2 <- shape_data(ids_data, age_name = "age", score_name = "y14", family = "BCPE")
mod2 <- fb_select(mydata2, age_name = "age", score_name = "shaped_score",
                  family = "BCPE", selcrit = "BIC")
norm2 <- normtable_create(mod2, mydata2, age_name = "age", score_name = "shaped_score")

composite_data <- composite_shape(list(norm1, norm2))}

}
\seealso{
\code{\link[=shape_data]{shape_data()}}, \code{\link[=fb_select]{fb_select()}}, \code{\link[=normtable_create]{normtable_create()}}
}
