% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_plot_novelty.R
\name{plot_novelty}
\alias{plot_novelty}
\title{Plot novelty of interviews over time}
\usage{
plot_novelty(
  score_df,
  refinements = integer(0),
  col = list(stroke = "black", fill_ref = "black", fill = "grey80")
)
}
\arguments{
\item{score_df}{(Dataframe) A dataframe of scored codes, as generated by \code{\link[=score_codes]{score_codes()}}.}

\item{refinements}{Either a list object generated by \code{\link[=import_field_notes]{import_field_notes()}},
or an Integer vector that lists when (in terms of interview sequence)
refinements were made to the interview questions. For example, \code{c(10, 15)}
means that interview questions were revised twice: First \strong{before} the
10th interview, and then again \strong{before} the 15th interview.}

\item{col}{(List) A List containing named Character vectors. Accepted names are:
\itemize{
\item \code{stroke} is the colour of point outlines as well as the line linking points together.
\item \code{fill_ref} is the colour of points after a refinement.
\item \code{fill} is the fill colour of points were no refinements were made.
}}
}
\value{
A ggplot object.
}
\description{
Novel codes are information that has not been previously mentioned by other
interviewees. The trend of 'novel' interview codes provides insight into the
richness of qualitative information.

This plot shows the trend of novel code generation; in the most basic way,
the higher the number, the richer the information that has been generated in
the study. By showing novel codes in context with any refinements to the
questions, it also shows how that trend may have been affected by those
refinements, and whether novel code generation is plateauing.

This chart alone should not be used to decide on a stopping point because it
does not show the richness of individual interviews; some interviews are richer
than others, therefore consider also using \code{\link[=plot_richness]{plot_richness()}} to look at the
richness of each interview in terms of novel and duplicate codes.
}
\examples{
# Field notes and coding matrices included with the package
path_to_notes    <- system.file("insect_study/records/refinements.xlsx", package = "novelqualcodes")
path_to_matrices <- system.file("insect_study/matrices/", package = "novelqualcodes")

# Import the data
my_refinements <- import_field_notes(path_to_notes)
my_matrices    <- import_coding_matrices(path_to_matrices)

# Score novel and duplicate codes
my_scores <- score_codes(my_matrices)

# Generate a plot with no refinements
plot_novelty(score_df = my_scores)

# Generate a plot using scored codes and imported refinements
plot_novelty(score_df = my_scores, refinements = my_refinements)

# Generate a plot using scored codes and a vector of refinement times
plot_novelty(score_df = my_scores, refinements = c(4, 8, 10))

# Add colours!

plot_novelty(
  score_df = my_scores,
  refinements = c(4, 8, 10),
  col = list(stroke    = "lightgreen",
             fill_ref  = "red",
             fill      = "blue")
)

}
\seealso{
\code{\link[=score_codes]{score_codes()}}, \code{\link[=import_field_notes]{import_field_notes()}}, \code{\link[=plot_richness]{plot_richness()}}, \code{\link[=save_last_plot]{save_last_plot()}}
}
