% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNpde-plotFunctions.R
\name{npde.plot.select}
\alias{npde.plot.select}
\title{Select plot for a NpdeObject object}
\usage{
npde.plot.select(npdeObject,data=FALSE,ecdf=FALSE,qqplot=FALSE, histogram=FALSE,
x.scatter=FALSE,pred.scatter=FALSE,x.box=FALSE,pred.box=FALSE, cov.scatter=FALSE, 
cov.x.scatter=FALSE, cov.pred.scatter=FALSE,cov.x.box=FALSE,cov.pred.box=FALSE, 
cov.ecdf=FALSE, cov.hist=FALSE, cov.qqplot=FALSE, vpc=FALSE,...)
}
\arguments{
\item{npdeObject}{an object returned by a call to \code{\link{npde}} or \code{\link{autonpde}}}

\item{data}{boolean, whether to produce a plot of the data}

\item{ecdf}{boolean, whether to produce a distribution plot of the empirical distribution function}

\item{qqplot}{boolean, whether to produce a QQ-plot of the empirical distribution function}

\item{histogram}{boolean, whether to produce a histogram of the metric}

\item{x.scatter}{boolean, whether to produce a scatterplot of the metric as a function of X}

\item{pred.scatter}{boolean, whether to produce a scatterplot of the metric as a function of predictions}

\item{x.box}{boolean, whether to produce whisker plots of the metric as a function of X}

\item{pred.box}{boolean, whether to produce whisker plots of the metric as a function of predictions}

\item{cov.scatter}{boolean, whether to produce a scatterplot of the metric as a function of covariate(s)}

\item{cov.x.scatter}{boolean, whether to produce a scatterplot of the metric as a function of X, split by covariate(s)}

\item{cov.pred.scatter}{boolean, whether to produce a scatterplot of the metric as a function of predictions, split by covariate(s)}

\item{cov.x.box}{boolean, whether to produce whisker plots of the metric as a function of X, split by covariate(s)}

\item{cov.pred.box}{boolean, whether to produce whisker plots of the metric as a function of predictions, split by covariate(s)}

\item{cov.ecdf}{boolean, whether to produce a distribution plot of the empirical distribution function, split by covariate(s)}

\item{cov.hist}{boolean, whether to produce a distribution plot of the empirical distribution function, split by covariate(s)}

\item{cov.qqplot}{boolean, whether to produce a distribution plot of the empirical distribution function, split by covariate(s)}

\item{vpc}{boolean, whether to produce a VPC}

\item{\dots}{additional arguments to be passed on to the function, to control which metric (npde, pd, npd) is used or to override graphical parameters (see the PDF document for details, as well as \code{\link{set.plotoptions}})}
}
\value{
a ggplot object or a list of ggplot objects (grobs)
}
\description{
Select plot for a NpdeObject object
}
\references{
K. Brendel, E. Comets, C. Laffont, C. Laveille, and F.
Mentre. Metrics for external model evaluation with an application to the
population pharmacokinetics of gliclazide. \emph{Pharmaceutical Research},
23:2036--49, 2006.
}
\seealso{
\code{\link{npde}}, \code{\link{autonpde}}, \code{\link{set.plotoptions}}
}
\author{
Emmanuelle Comets <emmanuelle.comets@bichat.inserm.fr>
}
\keyword{plot}
