% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_scores.R
\name{find_scores}
\alias{find_scores}
\title{Calculate scores}
\usage{
find_scores(
  formula,
  data,
  method,
  t_star = NULL,
  s_star = NULL,
  rho = NULL,
  gamma = NULL,
  tau = NULL,
  timefix = TRUE
)
}
\arguments{
\item{formula}{Formula object. The response (on the left of the \code{~} operator) must be a survival object as returned by the \code{Surv} function.
The terms (on the right of the \code{~} operator) must include the treatment arm indicator, and additionally can include strata using the \code{strata} function.}

\item{data}{Data frame containing time-to-event data.}

\item{method}{Character string specifying type of method to calculate scores. Either one of the weighted log-rank tests
(log-rank \code{"lr"}, Fleming-Harrington \code{"fh"}, modestly weighted \code{"mw"}) or pseudovalue-based scores (restricted mean survival time \code{"rmst"},
milestone analysis \code{"ms"})}

\item{t_star}{Parameter \eqn{t^*} in the modestly weighted (\code{"mw"}) test, see Details.}

\item{s_star}{Parameter \eqn{s^*} in the modestly weighted (\code{"mw"}) test, see Details.}

\item{rho}{Parameter \eqn{\rho} in the Fleming-Harrington (\code{"fh"}) test, see Details.}

\item{gamma}{Parameter \eqn{\gamma} in the Fleming-Harrington (\code{"fh"}) test, see Details.}

\item{tau}{Parameter \eqn{\tau} in the RMST (\code{"rmst"}) or milestone analysis  (\code{"ms"}) test.}

\item{timefix}{Deal with floating point issues (as in the survival package). Default is TRUE. May need to set FALSE for simulated data.}
}
\value{
Data frame. Each row corresponds to an event or censoring time.
At each time specified in \code{t_j} the columns indicate
\itemize{
\item \code{event} the event indicator
\item \code{group} the treatment arm indicator
\item \code{score} the assigned score at time \code{t_j}
\item \code{standardized_score} the value of \code{score} standardized to be between -1 and 1
}
}
\description{
Weighted log-rank tests can also be thought in terms of assigning a score to the each of
the events (including censoring) and comparing the average score on each arm, see Magirr (2021) \url{doi:10.1002/pst.2091}.
This function calculates the scores
for different types of weighted log-rank test,
the modestly-weighted log-rank test and the Fleming-Harrington (\eqn{\rho},\eqn{\gamma})
test, in addition to the standard log-rank test.
}
\details{
Select which of the tests to perform using argument \code{method}.
For the weighted log-rank tests, the output is calculated as outlined in \code{vignette("weighted_log_rank_tests", package="nphRCT")}.
}
\examples{
library(nphRCT)
set.seed(1)
sim_data <- sim_events_delay(
  event_model=list(
    duration_c = 36,
    duration_e = c(6,30),
    lambda_c = log(2)/9,
    lambda_e = c(log(2)/9,log(2)/18)
  ),
  recruitment_model=list(
    rec_model="power",
    rec_period = 12,
    rec_power = 1
  ),
  n_c=50,
  n_e=50,
  max_cal_t = 36
)
df_scores<-find_scores(formula=Surv(event_time,event_status)~group,
  data=sim_data,
  method="mw",
  t_star = 4
)
plot(df_scores)
}
\references{
Magirr, D. (2021).
Non-proportional hazards in immuno-oncology: Is an old perspective needed?.
Pharmaceutical Statistics, 20(3), 512-527.
\url{doi:10.1002/pst.2091}

Magirr, D. and Burman, C.F., 2019.
Modestly weighted logrank tests.
Statistics in medicine, 38(20), 3782-3790.
}
