% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npsp-rules.R
\name{rule}
\alias{rule}
\alias{rule.binning}
\alias{rule.binning.default}
\alias{rule.svar}
\alias{rule.svar.default}
\alias{rule.svar.bin.den}
\title{npsp Rules}
\usage{
rule(x, d = 1, rule = c("Rice", "Sturges", "scott", "FD"), ...)

rule.binning(x, ...)

\method{rule.binning}{default}(x, d = ncol(x), a = 2, b = d + 1, ...)

rule.svar(x, ...)

\method{rule.svar}{default}(x, d = ncol(x), a = 2, b = d + 1, ...)

\method{rule.svar}{bin.den}(x, ...)
}
\arguments{
\item{x}{data vector or object used to select a method.}

\item{d}{(spatial) dimension.}

\item{rule}{character; rule to be used.}

\item{...}{further arguments passed to or from other methods.}

\item{a}{scale values.}

\item{b}{exponent values.}
}
\value{
The rule values (vector or scalar).

\code{rule.binning} returns a vector with the suggested number of bins
on each dimension.

\code{rule.binning.default} returns \code{rep(ceiling(a * nrow(x) ^ (1 / b)), d)}.

\code{rule.svar} returns the suggested number of bins
for variogram estimation.

\code{rule.svar.default} returns \code{ceiling(a * (nrow(x)^2 / 4) ^ (1 / b))}.
}
\description{
Compute the number of classes for a histogram,
the number of nodes of a binning grid, etc.
}
\details{
The Rice Rule, \eqn{m = \lceil 2 n^{1/3} \rceil,}
is a simple alternative to Sturges's rule (\code{\link{nclass.Sturges}}).
}
\seealso{
\code{\link{hist}}, \code{\link{nclass.Sturges}}, \code{\link{nclass.scott}},
\code{\link{nclass.FD}}, 
\code{\link{binning}}, \code{\link{np.den}}, \code{\link{bin.den}}.
}
