% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ntfy.R
\name{ntfy_history}
\alias{ntfy_history}
\title{Retrieve History of Notifications}
\usage{
ntfy_history(
  since = "all",
  topic = ntfy_topic(),
  server = ntfy_server(),
  auth = ntfy_auth(),
  username = ntfy_username(),
  password = ntfy_password(),
  ...
)
}
\arguments{
\item{since}{duration (e.g. \code{"10m"} or \code{"30s"}), a Unix timestamp (e.g.
\code{"1635528757"}), a message ID (e.g. \code{"nFS3knfcQ1xe"}), or \code{"all"} (all cached
messages)}

\item{topic}{subscribed topic to which to send notification}

\item{server}{ntfy server}

\item{auth}{logical indicating if the topic requires password authorization}

\item{username}{username with access to a protected topic.}

\item{password}{password with access to a protected topic.}

\item{...}{any other (named) query parameters to add to the request}
}
\value{
a \code{\link[=data.frame]{data.frame()}} with one row per notification, with columns as
described in the documentation
}
\description{
Retrieve History of Notifications
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# get the last hour of notifications
ntfy_history(since = "1h")
\dontshow{\}) # examplesIf}
}
\seealso{
\url{https://ntfy.sh/docs/subscribe/api/#json-message-format}
}
