% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-ts.r
\name{null_ts}
\alias{null_ts}
\title{Generate null data by simulating from a time series model.}
\usage{
null_ts(var, modelfn)
}
\arguments{
\item{var}{variable to model as a time series}

\item{modelfn}{method for simulating from ts model.}
}
\value{
a function that given \code{data} generates a null data set.
For use with \code{\link{lineup}} or \code{\link{rorschach}}
}
\description{
Null hypothesis: data follows a time series model using auto.arima from the forecast package
}
\examples{
require(forecast)
require(ggplot2)
require(dplyr)
data(aud)
l <- lineup(null_ts("rate", auto.arima), aud)
ggplot(l, aes(x=date, y=rate)) + geom_line() +
  facet_wrap(~.sample, scales="free_y") +
  theme(axis.text = element_blank()) +
  xlab("") + ylab("")
l_dif <- l \%>\%
  group_by(.sample) \%>\%
  mutate(d=c(NA,diff(rate))) \%>\%
  ggplot(aes(x=d)) + geom_density() +
  facet_wrap(~.sample)
}
\seealso{
null_model
}
