% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_daily_attendance_2018_2019.R
\name{nyc_daily_attendance_2018_2019}
\alias{nyc_daily_attendance_2018_2019}
\title{2018-2019 Daily Attendance}
\source{
NYC Open Data: <https://data.cityofnewyork.us/Education/2018-2019-Daily-Attendance/x3bb-kg5j/about_data>
}
\usage{
nyc_daily_attendance_2018_2019(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing 2018–2019 NYC Daily Student Attendance data.
}
\description{
Downloads 2018-2019 Daily Student Attendance from NYC Open Data.
}
\details{
Daily listing (counts) of students registered, present, absent and released by School DBN.
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_daily_attendance_2018_2019(limit = 10)
head(small_sample)

\donttest{
nyc_daily_attendance_2018_2019(limit = 5000)
nyc_daily_attendance_2018_2019(filters = list(school_dbn = "01M015"))
}
}
