% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_historic_load_data.R
\name{get_historic_load_data}
\alias{get_historic_load_data}
\title{Load historic yearly average load data}
\usage{
get_historic_load_data(longterm)
}
\arguments{
\item{longterm}{A data frame object with "country", "year", and "avg_hourly_demand" columns resulting from the function \code{\link{decompose_load_data}}.}
}
\value{
Data frame with "country", "year", and "avg_hourly_demand" (yearly average of hourly demand).
}
\description{
This function utilizes two historical load datasets obtained from the archive of https://www.entsoe.eu/data/power-stats/.
It calculates the hourly average load for each year and appends the results to the long-term dataframe generated by \code{\link{decompose_load_data}}.
}
\examples{

print("Input dataframe should be in the following form:")
example_decomposed_data$longterm
example_longterm_data <- get_historic_load_data(example_decomposed_data$longterm)
print("Historic load data is added starting from 2006.")
example_longterm_data

}
