% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyseStories.R
\name{analyseStories}
\alias{analyseStories}
\title{Analysing Stories}
\usage{
analyseStories(
  storiesFile,
  groupsNumber,
  topGroups = 1,
  sheetFilePath = NULL,
  reportFilePath = NULL,
  outputType = "pdf_document",
  ignoreWordsList = NULL
)
}
\arguments{
\item{storiesFile}{The path an name to a text file containing one user story
per line. They need to be written in English.}

\item{groupsNumber}{The number of groups you want to generate between user stories.}

\item{topGroups}{How many groups per stories you want to keep. The default is 1.}

\item{sheetFilePath}{The path and filename of the Excel sheet that will be
stored; must include the `*.xlsx` extension. If no value is passed, the
file will not be written.}

\item{reportFilePath}{The path where the extensive report will be stored. It
must include the correct extension (according to the type selected in the
following argument). If no value is passed, the report won't be generated.}

\item{outputType}{The type of document to be generated (from an RMarkdown). By default
it is a PDF file.}

\item{ignoreWordsList}{The list of words that you want to avoid using during
the grouping of user stories. If nothing is passed, a default list
will be used.}
}
\value{
A list of two datasets: the first one contains the stories split up,
    classified in types, analysed and grouped. Second dataframe contains top
    words per group and the belonging value of the word.
}
\description{
Main function that fully automates the process of analysing a
    dataset of user stories. It can also write results as an Excel sheet in
    a given directory, and generate an advanced report with highlights of
    missing features.
}
\examples{
# Libraries for the example
library(reshape2)

# Transform the stories
fileUrl <- example_stories()
stories <- analyseStories(fileUrl, 7)

# Print some information
head(dplyr::as_tibble(stories[[2]]))

head(stories[[1]])

}
\seealso{
Other Simplified Process: 
\code{\link{createIgnoreWords}()},
\code{\link{reportStories}()}
}
\concept{Simplified Process}
