% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_audio.R
\name{audio_transcription_request}
\alias{audio_transcription_request}
\title{API audio: speech to text (transcryption)}
\usage{
audio_transcription_request(
  file,
  model,
  language = NULL,
  prompt = NULL,
  response_format = NULL,
  temperature = NULL,
  file_type = NULL,
  api_key = api_get_key()
)
}
\arguments{
\item{file}{string/raw, content of the audio file or path to the audio file to transcribe, in one of these formats:
flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.}

\item{model}{string, ID of the model to use. Only 'whisper-1' is currently available.}

\item{language}{NULL/string, the language of the input audio. Supplying the input language in ISO-639-1 format will
improve accuracy and latency. See https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes}

\item{prompt}{NULL/string, an optional text to guide the model's style or continue a previous audio segment. The
prompt (https://platform.openai.com/docs/guides/speech-to-text/prompting) should match the audio language.}

\item{response_format}{NULL/string, The format of the transcript output, in one of these options: json (default),
text, srt, verbose_json, or vtt.}

\item{temperature}{NULL/double, the sampling temperature, between 0 and 1. Higher values like 0.8 will make the
output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model
will use log probability to automatically increase the temperature until certain thresholds are hit. 0 is default.}

\item{file_type}{NULL/string mime type of file (e.g. "audio/mpeg"). If NULL (default), will be guess by
mime::guess_type() when needed.}

\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
Transcribes audio into the input language. To get more details, visit
https://platform.openai.com/docs/api-reference/audio/createTranscription
https://platform.openai.com/docs/guides/speech-to-text
}
\examples{
\dontrun{
res_content <- audio_speech_request(
  "path/to/audio/file.mp3",
  "whisper-1",
  "en",
  response_format = "text"
)
if (!is_error(res_content)) {
  message(res_content)
}
}

}
